// wstestai.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"

// include the AI interface as exports
#define AI_INTERFACE_EXPORTS
#include "AIInterface.h"

#include <stdio.h>


#ifdef _MANAGED
#pragma managed(push, off)
#endif

BOOL APIENTRY DllMain( HMODULE hModule,
					  DWORD  ul_reason_for_call,
					  LPVOID lpReserved
					  )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		puts("WSTestAI: DLLMAIN - DLL_PROCESS_ATTACH");
		break;
	case DLL_THREAD_ATTACH:
		//puts("WSTestAI: DLLMAIN - DLL_THREAD_ATTACH");
		break;
	case DLL_THREAD_DETACH:
		//puts("WSTestAI: DLLMAIN - DLL_THREAD_DETACH");
		break;
	case DLL_PROCESS_DETACH:
		puts("WSTestAI: DLLMAIN - DLL_PROCESS_DETACH");
		break;
	}

	return TRUE;
}

#ifdef _MANAGED
#pragma managed(pop)
#endif

AI_INTERFACE_API void __stdcall initializeGame(void)
{
	puts("WSTestAI: initializeGame");
}

AI_INTERFACE_API int __stdcall initialize(const char *password)
{
	puts("WSTestAI: initializing");
	return true;
}

AI_INTERFACE_API BYTE __stdcall submitAIMoveResult(int rank, int result)
{
	printf("WSTestAI: submitAIMoveResult.  rank: %d  result: %d\n", rank, result);
	return AI_SPECIAL_MOVE_NOTHING;
}

AI_INTERFACE_API BYTE __stdcall submitOpponentMove(int xo, int yo, int xf, int yf, int rank, int result)
{
	printf("WSTestAI: oppMove: (%d, %d) -> (%d, %d). rank: %d  result: %d\n",
		xo, yo, xf, yf, rank, result);
	return 0;
}

AI_INTERFACE_API void __stdcall startGame(void)
{
	puts("WSTestAI: startGame");
}

AI_INTERFACE_API void __stdcall setOpponentSetupPiece(int x, int y)
{
	printf("WSTestAI: setOpponentSetupPiece: %d, %d\n", x, y);
}


AI_INTERFACE_API void __stdcall abortGame(int reason) 
{
	printf("WSTestAI: abortGame.  Reason: %d\n", reason);
}

AI_INTERFACE_API void __stdcall createAISetup(int color) 
{
	printf("WSTestAI: createAISetup.  color: %d\n", color);
}


AI_INTERFACE_API int __stdcall createGame(void) 
{
	puts("WSTestAI: createGame");
	return OPTION_OFF; // OPTION_ON;
}


AI_INTERFACE_API void __stdcall gameCreated(void) 
{
	puts("WSTestAI: gameCreated");
}


AI_INTERFACE_API void __stdcall gameJoined(void) 
{
	puts("WSTestAI: gameJoined");
}


AI_INTERFACE_API int __stdcall getAISetupPiece(int x, int y) 
{
	printf("WSTestAI: getAISetupPiece(%d,%d)\n", x, y);
	return RANK_SPY;
}


AI_INTERFACE_API int __stdcall getCreateGameMode(void) 
{
	puts("WSTestAI: getCreateGameMode");
	return GAMEMODE_CLASSIC;
}


AI_INTERFACE_API int __stdcall getCreateGameOption(int option) 
{
	printf("WSTestAI: getCreateGameOption.  Option: %d\n", option);
	return OPTION_OFF;
}


AI_INTERFACE_API const char * __stdcall getPublicName(void) 
{
	puts("WSTestAI: getPublicName");
	return "WSTestAI";
}

AI_INTERFACE_API const char * __stdcall getPreGameChat(void) 
{
	puts("WSTestAI: getPreGameChat");
	return "good luck";
}


AI_INTERFACE_API const char * __stdcall getPostGameChat(void) 
{
	puts("WSTestAI: getPostGameChat");
	return "good game";
}


AI_INTERFACE_API void __stdcall endGame(int result, int reason) 
{
	printf("WSTestAI: endGame.  Result: %d   Reason: %d\n", result, reason);
}

AI_INTERFACE_API void __stdcall postGameLogOriginalOpponentSetup(int x, int y, int rank)
{
	printf("WSTestAI: postGameLogOriginalOpponentSetup.  (%d,%d)=%d\n", x, y, rank);
}

AI_INTERFACE_API void __stdcall postGameLogStart()
{
	printf("WSTestAI: postGameLogStart()\n");
}

AI_INTERFACE_API void __stdcall postGameLogClose()
{
		printf("WSTestAI: postGameLogClose()\n");
}

AI_INTERFACE_API void __stdcall getAIMove(BYTE *move) 
{
	move[0] = 1;
	move[1] = 2;
	move[2] = 3;
	move[3] = 4;
	move[4] = 0;

	printf("WSTestAI: getAIMove: (%d, %d) -> (%d, %d)  special: %d\n",
		move[0], move[1], move[2], move[3], move[4]);
}


AI_INTERFACE_API BYTE __stdcall illegalMove(BYTE *move) 
{
	printf("WSTestAI: illegalMove: (%d, %d) -> (%d, %d)  special: %d\n",
		move[0], move[1], move[2], move[3], move[4]);
	return AI_SPECIAL_MOVE_NOTHING;
}


AI_INTERFACE_API void __stdcall illegalSetup(int x, int y, int rank) 
{
	printf("WSTestAI: illegalSetup. (%d, %d)  Rank: %d\n", x, y, rank);
}


AI_INTERFACE_API int __stdcall joinGame(void) 
{
	puts("WSTestAI: joinGame");
	return OPTION_OFF;
}

AI_INTERFACE_API int __stdcall newGameCreated(const char *owner, int mode) 
{
	printf("WSTestAI: newGameCreated.  Owner: %s  Mode: %d\n", owner, mode);
	return OPTION_OFF;
}


AI_INTERFACE_API int __stdcall newGameOption(int option, int value) 
{
	printf("WSTestAI: newGameOption.  Option: %d  Value: %d\n", option, value);
	return OPTION_ON;
}


AI_INTERFACE_API void __stdcall setAIUsername(const char *aiUsername) 
{
	printf("WSTestAI: AI name: %s\n", aiUsername);
}


AI_INTERFACE_API void __stdcall setOpponentUsername(const char *opponentName) 
{
	printf("WSTestAI: opponent: %s\n", opponentName);
}

AI_INTERFACE_API void __stdcall setGameAids(int value) 
{
	printf("WSTestAI: setGameAids: %d\n", value);
}

AI_INTERFACE_API int __stdcall setGameOption(int option, int value) 
{
	printf("WSTestAI: setGameOption.  Option: %d  Value: %d\n", option, value);
	return OPTION_ON;
}


AI_INTERFACE_API int __stdcall setSkillLevel(int level) 
{
	printf("WSTestAI: skill level: %d\n", level);
	return OPTION_ON;
}


AI_INTERFACE_API int __stdcall setMoveTimeLimit(int turnTimeLimitSecs) 
{
	printf("WSTestAI: move time limit: %d\n", turnTimeLimitSecs);
	return OPTION_ON;
}


AI_INTERFACE_API int __stdcall setCustomPieceCount(int marshals, int generals, int colonels, int majors,
										 int captains, int lieutenants, int sergeants, int miners, int scouts, int spies, int bombs,
										 int flags) 
{
	printf("WSTestAI: custom piece count: %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d\n",
		marshals, generals, colonels, majors, captains, lieutenants, sergeants, miners, scouts, spies, bombs, flags);
	return OPTION_OFF;
}


AI_INTERFACE_API int __stdcall setGameMode(int mode) 
{
	printf("WSTestAI: setGameMode %d\n", mode);
	return OPTION_ON;
}

AI_INTERFACE_API void __stdcall terminate(void)
{
	puts("WSTestAI: terminating");
}

